<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Common;

use Erlage\Photogram\Data\Dtos\AbstractDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintValidatorDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintTransformerDTO;

class ApiCompatibilityDTO extends AbstractDTO
{
    /**
     * to comply with DTO interface
     */
    use TraitComplaintValidatorDTO;
    use TraitComplaintTransformerDTO;

    const DTO_NAME = 'api_compatibility_dto';

    /*
    |--------------------------------------------------------------------------
    | key map
    |--------------------------------------------------------------------------
    */

    const KEY_STATUS = 'status';

    const KEY_MESSAGE = 'message';

    const KEY_IOS_UPDATE_URL = 'ios_update_url';

    const KEY_ANDROID_UPDATE_URL = 'android_update_url';

    /*
    |--------------------------------------------------------------------------
    | possible values
    |--------------------------------------------------------------------------
    */

    const STATUS_SUPPORTED = 'supported';

    const STATUS_REQUIRES_UPDATE = 'requires_update';

    /*
    |--------------------------------------------------------------------------
    | data
    |--------------------------------------------------------------------------
    */

    /**
     * @var string
     */
    private $status;

    /**
     * @var string
     */
    private $message;

    /**
     * @var string
     */
    private $iosUpdateUrl;

    /**
     * @var string
     */
    private $androidUpdateUrl;

    /*
    |--------------------------------------------------------------------------
    | setters
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public function setStatus(string $status)
    {
        $this -> status = $status;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMessage(string $message)
    {
        $this -> message = $message;

        return $this;
    }

    /**
     * @return static 
     */
    public function setIosUpdateUrl(string $iosUpdateUrl)
    {
        $this -> iosUpdateUrl = $iosUpdateUrl;

        return $this;
    }

    /**
     * @return static 
     */
    public function setAndroidUpdateUrl(string $androidUpdateUrl)
    {
        $this -> androidUpdateUrl = $androidUpdateUrl;

        return $this;
    }

    /*
    |--------------------------------------------------------------------------
    | from json
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public static function fromJsonMap(array $data)
    {
        return (new static())
            -> setStatus((string) $data[self::KEY_STATUS])
            -> setMessage((string) $data[self::KEY_MESSAGE])
            -> setIosUpdateUrl((string) $data[self::KEY_IOS_UPDATE_URL])
            -> setAndroidUpdateUrl((string) $data[self::KEY_ANDROID_UPDATE_URL]);
    }

    /*
    |--------------------------------------------------------------------------
    | serialization for json_encode
    |--------------------------------------------------------------------------
    */

    public function jsonSerialize()
    {
        return array(
            self::KEY_STATUS             => $this -> status,
            self::KEY_MESSAGE            => $this -> message,
            self::KEY_IOS_UPDATE_URL     => $this -> iosUpdateUrl,
            self::KEY_ANDROID_UPDATE_URL => $this -> androidUpdateUrl,
        );
    }

    /*
    |--------------------------------------------------------------------------
    | implement DTO methods
    |--------------------------------------------------------------------------
    */

    /**
     * @param ApiCompatibilityDTO $apiCompatibilityDTO
     */
    public static function serialize($apiCompatibilityDTO): string
    {
        return \json_encode($apiCompatibilityDTO);
    }

    /**
     * @return ApiCompatibilityDTO
     */
    public static function deSerialize(string $apiCompatibilityDTO)
    {
        $data = \json_decode($apiCompatibilityDTO, true);

        return static::fromJsonMap($data);
    }
}
